﻿<# 2021.02.02 - Updated
WaaS Info Script Phase 1 of 2.
WaaS Info Script Phase 1, Step 2 of 2 
Phase 1 is at start of TS, grabs basic info and writes to registry.

  IPU Keys:
   IPULastRun
   IPUAttempts
   WaaS_Stage

   Changes:
   2021.06.08 - Added Logging into SMSTSlog


#>

#Function to increment the IPUAttemps Key for each run

function Set-RegistryValueIncrement {
    [cmdletbinding()]
    param (
        [string] $path,
        [string] $Name
    )

    try { [int]$Value = Get-ItemPropertyValue @PSBoundParameters -ErrorAction SilentlyContinue } catch {}
    Set-ItemProperty @PSBoundParameters -Value ($Value + 1).ToString() 
}


#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
}
catch
{
	Write-Verbose "Not running in a task sequence."
}

if ($tsenv)
    {
    $ScriptVer = "21.06.08"
    Write-Output "-----------------------------------------"
    Write-Output "Starting - Inventory IPU Start Results Script (POST Pre-Flight): $ScriptVer "

    $tsBuild = $tsenv.Value("WaaS_UpgradeBuild") #Get Build Number from TS Variable.
    $registryPath = "HKLM:\$($tsenv.Value("RegistryPath"))\$tsBuild" #Sets Registry Location

    
    #Create Registry Keys if needed
    if ( -not ( test-path $registryPath ) ) { 
        new-item -ItemType directory -path $registryPath -force -erroraction SilentlyContinue | out-null
    }

    #Writes Into to the WaaS\Build Number\ Key
    New-ItemProperty -Path $registryPath -Name "IPULastRun" -Value $TSEnv.Value('SMSTS_StartTSTime') -Force | Out-Null
    Write-Output " Writing IPULastRun Value to $($TSEnv.Value('SMSTS_StartTSTime'))"

    #Creates or Increments the IPUAttempts Value
    Set-RegistryValueIncrement -Path $registryPath -Name IPUAttempts
    Write-Output " Writing IPUAttempts to $((Get-Item -Path $registrypath).getValue("IPUAttempts"))"
   
    #Updates WaaS Value to Deployment Started
    New-ItemProperty -Path $registryPath -Name "WaaS_Stage" -Value "Deployment_Started" -Force | Out-Null
    Write-Output " Writing WaaS_Stage Value to Deployment_Started"
    
    Write-Output "Completed - Inventory IPU Start Results Script (POST Pre-Flight): $ScriptVer "
    Write-Output "-----------------------------------------"
    }